/*
 * TableWidget.cpp
 *
 *  Created on: 10.03.2011
 *      Author: stefan.detter
 */

#include "TableWidget.h"

#include <QHeaderView>

TableWidget::TableWidget( QWidget * parent )
	: QTableWidget(parent)
{
	QTableWidget::horizontalHeader()->setStretchLastSection(true);
}

TableWidget::~TableWidget()
{
}

void TableWidget::setColumnPercentWidth ( int column, uchar percent )
{
	m_percentWidth.resize(this->model()->columnCount());

	m_percentWidth[column] = percent;
}

void TableWidget::resizeEvent ( QResizeEvent * event )
{
	int width = this->size().width();
	double percWidth = ((double)width)/101.0;
	for(int i = 0; i < m_percentWidth.size(); i++)
	{
		if(m_percentWidth.at(i) != 0){
			int colWidth = m_percentWidth.at(i) * percWidth;
			if(colWidth == 0) colWidth = 1;
			this->setColumnWidth(i, colWidth);
		}
	}

	QTableWidget::resizeEvent(event);
}


